from django.shortcuts import render, redirect
from django.views.generic.base import TemplateView
from .models import Demographic, Finances
from django.contrib.auth.decorators import login_required
from django.contrib.auth.models import User
from django.http import HttpResponse , JsonResponse

from .forms import FinancesForm
class IndexPageView(TemplateView):
    template_name = 'main/x.html'

class ChangeLanguageView(TemplateView):
    template_name = 'main/change_language.html'

@login_required
def dash(request):
    return render(request, 'main/dash.html', {})

@login_required
def home(request, toast=None):
    active_users = len((User.objects.filter(is_active=True)))
    active_users -= 2 # test accounts
    return render(request, 'main/index.html', {'active_users':active_users, 'toast':toast})

@login_required
def finances(request, toast=None):
    try:
        finance = Finances.objects.get(user=request.user)
    except Finances.DoesNotExist:
        finance = Finances.objects.create(user = request.user)
        finance.save()
    if request.method == 'POST':
        finance.hours = request.POST['hours']
        # finance.status = request.POST['status']
        finance.total = request.POST['total']
        finance.year_to_date = request.POST['year_to_date']
        finance.save()
    return render(request, 'main/finances.html', {'form':FinancesForm(),'user':request.user,'finance':finance, 'toast':toast})

@login_required
def demographic(request):
    if request.method == 'POST':
        try:
            data = {}
            for key in request.POST:
                if not key in ["csrfmiddlewaretoken"]:
                    data[key]="".join(request.POST[key])
            demo = Demographic.objects.create(user = request.user,**data)
            demo.save()
            toast = "Saved Successfully!"
        except Exeception:
            "Failed to save data, Exeception"
            return redirect("main:home",toast=toast)
    try:
        Demographic.objects.get(user=request.user)
        filled = True
    except:
        filled = False
    return render(request, 'main/demographic.html', {"filled":filled})

def test(request):
    a = ((User.objects.filter(is_active=True)))
    return HttpResponse("ok",a)