from django.db import models
from django.contrib.auth.models import User
import datetime

class Finances(models.Model):
    user = models.OneToOneField(User, on_delete=models.CASCADE)
    year_to_date = models.IntegerField(default=0)
    hours = models.IntegerField(default=0)
    status = models.IntegerField(default=0)
    total = models.IntegerField(default=0)

    def __str__(self):
        return self.user.username + " \t| Total = " + str(self.total)+ " \t| Hours = " + str(self.hours )

class Dweet(models.Model):
    user = models.OneToOneField(User, on_delete=models.CASCADE)
    hours = models.IntegerField(default=0)
    status = models.CharField(max_length=1000)
    total = models.IntegerField(default=0)

    def __str__(self):
        return self.user.username + " \t| Total = " + str(self.total)+ " \t| Hours = " + str(self.hours )


class Demographic(models.Model):
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    # date_created = models.DateTimeField(auto_now_add=True)
    # date_updated = models.DateTimeField(null=True, default=None)

    name = models.CharField(max_length=15)
    sex = models.CharField(max_length=15)
    date_of_birth = models.DateField(null=True, default=None)
    SSN = models.CharField(max_length=20)
    passport = models.CharField(max_length=50)
    national_id = models.CharField(max_length=20)
    birth_certificate = models.CharField(max_length=30)
    mother_name = models.CharField(max_length=40)
    father_name = models.CharField(max_length=40)
    marital_status = models.CharField(max_length=30)
    wife_name = models.CharField(max_length=40)
 
    current_address = models.CharField(max_length=150)
    permanent_address = models.CharField(max_length=150)
 
    cell_phone = models.CharField(max_length=15)
    wife_cell_phone = models.CharField(max_length=15)
    office_phone = models.CharField(max_length=15)
    home_phone = models.CharField(max_length=15)
    email1 = models.CharField(max_length=35)
    email2 = models.CharField(max_length=35)
    mother_phone = models.CharField(max_length=15)
    sister_phone = models.CharField(max_length=15)
    brother_phone = models.CharField(max_length=15)
 
    first_emergency_contact = models.CharField(max_length=40)
    phone = models.CharField(max_length=15)
    fax = models.CharField(max_length=15)
    permanent_address = models.CharField(max_length=150)


    def __str__(self):
        return self.user.username + "\t| Name = " + self.name.ljust(25).rjust(30) + " \t| Age = " + str((datetime.date.today() - self.date_of_birth).days//365) if  self.date_of_birth else "dob empty"
    # def save(self, *args, **kwargs):

    #     if  not self.date_created:
    #         self.date_updated = datetime.datetime.now()

    #     super(demographic, self).save(*args, **kwargs)